#include <Massenger.h>

/*
Exemple qui démontre comment recevoir et envoyer des messages avec Massenger.

Allumer/Éteindre une DEL sur la broche 13 avec des 'massages' ASCII
Pour allumer la DEL :  d13 1 
Pour éteindre la DEL :  d13 0
Toujours terminer un 'massage' par un retour de chariot.

Chaque fois que la valeur de analogRead(0) change, 
Pour que la valeur soit retenue comme le message ASCII suivant : a0 xxx
('xxx' est la nouvelle valeur.)
Le 'massage' se termine toujours par un retour de chariot.
*/

// Instancier un nouvel objet Massenger, 
// le lier à la fonction du port Série
// Lier un appel de fonction lorsque le message est reçu.
Massenger massenger = Massenger( &Serial , massageReceived); 

// Une variable pour 'stocker' la valeur lue par 'AnalogRead' car nous ne voulons déclencher 
// l'exécution du code que lorsque celle-ci change.

int value;

void setup() {
  
  // initialiser la communication Sérielle.
  Serial.begin(57600); 
    
  // La broche 13 est déclarée comme une sortie.
  pinMode(13,OUTPUT); 
    
}

void loop() {
  
  // Vérifier s'il y a des nouveaux 'massages'. 
 massenger.update();
 
 // Comparer la nouvelle valeur avec celle qui est stockée.
   // Instancier une nouvelle variable de type 'nombre entier' et y écrire '0'.
 int valeur = 0; 
 int nouvelleValeur = analogRead(0);
 if ( nouvelleValeur != valeur ) {
   // Si newValue n'est pas égale à value alors l'envoyer.
     valeur = nouvelleValeur;
     massenger.send("a0",valeur);
 }

  
}

// Si un nouveau 'massage' est reçu.
void massageReceived() {
    
  if ( massenger.checkAddr("d13") ) { // Si le 'massage' commence par 'd13'
     int etatDEL = massenger.getInt(); // ...lire le prochain élément comme un nombre entier...
     digitalWrite(13,etatDEL); // ...et écrire la valeur suivante à la broche 13.
  }
  
}

